using System;
using System.Reflection;

using Microsoft.DirectX;
using Microsoft.DirectX.DirectInput;

using DarkStrideToolbox;


namespace DarkStride.StellarLanes.SharedDLL
{
	public enum enumNetMsg
	{
		//Player maintance messages
		RequestingSessionList,
		RequestingPlayerList,
		IsPatchAvailable,
		PatchAvailabilityResponse,

		//Lobby messages
		AddSession,
		DelSession,
		LobbyChat,
		JoinSession,
		QuitSession,
		AddPlayer,
		DelPlayer,

		//In game messages
		EntityUpdate,
		RemoveEntity,
		EntityLiteUpdate,
		EntityKeyPress,
		SessionUpdate,
		Respawn,
		GameChat,
		EntityReceivesLoot,
		EntityRemoveChassis,
		SetEntityInPlayStatus,
		EntityMessage,
		EntityReceivesEXP,
		RollingText,
        ZonesUpdate,

		//Wave management
		StartWave
	}


	public class NetMsg
	{
		public static void StopObsoletePackets( DSNetworkWrapper oNetwork )
		{
			//In game messages
			oNetwork.StopObsoletePackets( (int)enumNetMsg.EntityUpdate );
			oNetwork.StopObsoletePackets( (int)enumNetMsg.EntityLiteUpdate );
			oNetwork.StopObsoletePackets( (int)enumNetMsg.EntityKeyPress );
			oNetwork.StopObsoletePackets( (int)enumNetMsg.SetEntityInPlayStatus );
		}
        
		public static void Send_AddSession( DSNetworkWrapper oNetwork,DSNetworkPlayer oSendTo,Session oSession )
		{
			DSNetworkPacket oPacket = NetMsg.Pckt_AddSession( oSession );
			oNetwork.SendMsg( oSendTo,oPacket );
		}
		public static DSNetworkPacket Pckt_AddSession( Session oSession )
		{
			DSNetworkPacket oPacket = new DSNetworkPacket( Convert.ToInt32( enumNetMsg.AddSession ),oSession.SessionName,oSession.GUID );
			oPacket.GuarenteedDelivery = true;
			return( oPacket );
		}
		public static void Rcv_AddSession( DSNetworkPacket oPacket,ref string sSessionName,ref string sGUID )
		{
			sSessionName = (string)oPacket.GetParamater( 0 );
			sGUID = (string)oPacket.GetParamater( 1 );
		}
        
		public static void Send_DelSession( DSNetworkWrapper oNetwork,DSNetworkPlayer oSendTo,Session oSession )
		{
			DSNetworkPacket oPacket = NetMsg.Pckt_DelSession( oSession );
			oNetwork.SendMsg( oSendTo,oPacket );
		}
		public static DSNetworkPacket Pckt_DelSession( Session oSession )
		{
			DSNetworkPacket oPacket = new DSNetworkPacket( Convert.ToInt32( enumNetMsg.DelSession ),oSession.GUID );
			oPacket.GuarenteedDelivery = true;
			return( oPacket );
		}
		public static void Rcv_DelSession( DSNetworkPacket oPacket,ref string sGUID )
		{
			sGUID = (string)oPacket.GetParamater( 0 );
		}

		public static void Send_LobbyChat( DSNetworkWrapper oNetwork,DSNetworkPlayer oSender,DSNetworkPlayer oSendTo,string sMessage )
		{
			DSNetworkPacket oPacket = NetMsg.Pckt_LobbyChat( oSender,sMessage );
			oNetwork.SendMsg( oSendTo,oPacket );
		}
		public static DSNetworkPacket Pckt_LobbyChat( DSNetworkPlayer oSender,string sMessage )
		{
			DSNetworkPacket oPacket = new DSNetworkPacket( Convert.ToInt64( enumNetMsg.LobbyChat ),oSender.SocketID.ToString(),sMessage );
			return( oPacket );
		}
		public static void Rcv_LobbyChat( DSNetworkPacket oPacket,ref long nSenderSocketID,ref string sMessage )
		{
			nSenderSocketID = Convert.ToInt64( oPacket.GetParamater( 0 ) );
			sMessage = (string)oPacket.GetParamater( 1 );
		}

		public static void Send_RequestingSessionList( DSNetworkWrapper oNetwork,DSNetworkPlayer oSendTo )
		{
			DSNetworkPacket oPacket = new DSNetworkPacket( Convert.ToInt32( enumNetMsg.RequestingSessionList ) );
			oPacket.GuarenteedDelivery = true;
			oNetwork.SendMsg( oSendTo,oPacket );
		}
        
        public static void Send_RequestingPlayerList( DSNetworkWrapper oNetwork,DSNetworkPlayer oSendTo )
		{
			DSNetworkPacket oPacket = new DSNetworkPacket( Convert.ToInt32( enumNetMsg.RequestingPlayerList ) );
			oPacket.GuarenteedDelivery = true;
			oNetwork.SendMsg( oSendTo,oPacket );
		}
        
		public static void Send_JoinSession( DSNetworkWrapper oNetwork,DSNetworkPlayer oSendTo,DSNetworkPlayer oPlayerJoining,string sSessionGUID )
		{
			DSNetworkPacket oPacket = new DSNetworkPacket( Convert.ToInt32( enumNetMsg.JoinSession ),
							oPlayerJoining.SocketID.ToString(),
							sSessionGUID );
			oPacket.GuarenteedDelivery = true;
			oNetwork.SendMsg( oSendTo,oPacket );
		}
		public static void Rcv_JoinSession( DSNetworkPacket oPacket,ref string sSessionGUID,ref int nPlayerJoiningsSocketID )
		{
			nPlayerJoiningsSocketID = Convert.ToInt32( oPacket.GetParamater( 0 ) );
			sSessionGUID = (string)oPacket.GetParamater( 1 );
		}
        
		public static void Send_QuitSession( DSNetworkWrapper oNetwork,DSNetworkPlayer oSendTo,DSNetworkPlayer oPlayerJoining,string sSessionGUID )
		{
			oNetwork.SendMsg( oSendTo,Convert.ToInt32( enumNetMsg.QuitSession ),
							oPlayerJoining.SocketID.ToString(),
							sSessionGUID );
		}
		public static void Rcv_QuitSession( DSNetworkPacket oPacket,ref string sSessionGUID,ref int nPlayerQuitingsSocketID )
		{
			nPlayerQuitingsSocketID = Convert.ToInt32( oPacket.GetParamater( 0 ) );
			sSessionGUID = (string)oPacket.GetParamater( 1 );
		}
        
		public static void Send_EntityUpdate( DSNetworkWrapper oNetwork,DSNetworkPlayer oSendTo,Session oSession,Entity oEntity )
		{
            DSNetworkPacket oPacket = NetMsg.Pckt_EntityUpdate(oSession,oEntity);
			oNetwork.SendMsg( oSendTo,oPacket );
		}
		public static DSNetworkPacket Pckt_EntityUpdate( Session oSession,Entity oEntity )
		{
			DSNetworkPacket oPacket = new DSNetworkPacket( 
					Convert.ToInt32( enumNetMsg.EntityUpdate ),
					oEntity.PKey.ToString(),
					oEntity.GetType().Name, //.FullName,
					//oEntity.GetType().Assembly.FullName,
                    oEntity.Serialize(oSession).Serialize());
            oPacket.GuarenteedDelivery = true;
			return( oPacket );
		}
		public static void Rcv_EntityUpdate( DSNetworkPacket oPacket,ref string sPKey,ref Entity oNewObjOfType,ref string sSerializedStr )
		{
			Assembly oControlAssembly = null;
			Type oControlType = null;


			sPKey = (string)oPacket.GetParamater( 0 );
			sSerializedStr = (string)oPacket.GetParamater( 2 );

			//Deserialize the form into a new object... so first create the new object
			oControlAssembly = Assembly.Load("StellarLanes");//.LoadWithPartialName( "StellarLanes" );//(string)oPacket.GetParamater( 1 ) );
			oControlType = oControlAssembly.GetType( "DarkStride.StellarLanes.SharedDLL." + (string)oPacket.GetParamater( 1 ) );
			//Make it!
			oNewObjOfType = (Entity)Activator.CreateInstance( oControlType,new object[]{} );
			//Now deserialize the form
			//oNewObjOfType.DeSerialize( sSerializedStr );
		}

		public static void Send_EntityLiteUpdate( DSNetworkWrapper oNetwork,DSNetworkPlayer oSendTo,Entity oEntity )
		{
			DSNetworkPacket oPacket = NetMsg.Pckt_EntityLiteUpdate( oEntity );
			oNetwork.SendMsg( oSendTo,oPacket );
		}
		public static DSNetworkPacket Pckt_EntityLiteUpdate( Entity oEntity )
		{
			/*DSSerialize oSerialize = new DSSerialize();

			
			oSerialize.Set( 0,oEntity.Pos.X );
			oSerialize.Set( 1,oEntity.Pos.Y );
			oSerialize.Set( 2,oEntity.Vel.X );
			oSerialize.Set( 3,oEntity.Vel.Y );
			oSerialize.Set( 4,oEntity.Angle );
			oSerialize.Set( 5,oEntity.AngularMomentum );*/

			DSNetworkPacket oPacket = new DSNetworkPacket( 
				Convert.ToInt32( enumNetMsg.EntityLiteUpdate ),
				oEntity.PKey,
				oEntity.Location.Serialize().Serialize() );


			return( oPacket );
		}
		public static void Rcv_EntityLiteUpdate( DSNetworkPacket oPacket,ref string sEntityGUID,ref Location oServerLocation )
		{
			//float nX = 0, nY = 0;
			DSSerialize oSerialize = new DSSerialize();
			oServerLocation = new Location();

			oSerialize.DeSerialize( (string)oPacket.GetParamater( 1 ) );
			oServerLocation.DeSerialize( oSerialize );

			sEntityGUID = (string)oPacket.GetParamater( 0 );

			/*oSerialize.DeSerialize( (string)oPacket.GetParamater( 1 ) );

			nX = oSerialize.GetFloat( 0 );
			nY = oSerialize.GetFloat( 1 );
			oServerLocation.Pos = new Vector2( nX,nY );

			nX = oSerialize.GetFloat( 2 );
			nY = oSerialize.GetFloat( 3 );
			oServerLocation.Vel = new Vector2( nX,nY );
			
			oServerLocation.Angle = oSerialize.GetDouble( 4 );
			oServerLocation.AngularMomentum = oSerialize.GetDouble( 5 );*/
		}

		public static void Send_SessionUpdate( DSNetworkWrapper oNetwork,DSNetworkPlayer oSendTo,Session oSession )
		{
            DSNetworkPacket oPacket = new DSNetworkPacket(
                        Convert.ToInt32(enumNetMsg.SessionUpdate),
                        oSession.GUID, oSession.Serialize());
			oPacket.GuarenteedDelivery = true;
			oNetwork.SendMsg( oSendTo,oPacket );
		}
		public static void Rcv_SessionUpdate( DSNetworkPacket oPacket,ref string sSessionGUID,ref string sSessionSerializedStr )
		{
			sSessionGUID = (string)oPacket.GetParamater( 0 );
			sSessionSerializedStr = (string)oPacket.GetParamater( 1 );
		}

        public static void Send_ZonesUpdate(DSNetworkWrapper oNetwork, DSNetworkPlayer oSendTo, Session oSession, System.Collections.Generic.List<DSNetworkPacket> oLargePacketsToSend)
        {
            int nZoneIdx = 0;
            DSNetworkPacket oPacket = null;

            foreach (Zone oLoopZone in oSession.Zones.Values)
            {
                oPacket = new DSNetworkPacket(
                         Convert.ToInt32(enumNetMsg.ZonesUpdate),
                         nZoneIdx, oSession.Zones.Count,
                         oLoopZone.Serialize(oSession));
                oPacket.GuarenteedDelivery = true;

                oLargePacketsToSend.Add(oPacket);
                //oNetwork.SendMsg(oSendTo, oPacket);
                nZoneIdx++;
            } 
        }
        public static void Rcv_ZonesUpdate(DSNetworkPacket oPacket, ref int nZoneIdx, ref int nZoneCount, ref string sZoneSerializedStr)
        {
            nZoneIdx = (int)oPacket.GetParamater(0);
            nZoneCount = (int)oPacket.GetParamater(1);
            sZoneSerializedStr = (string)oPacket.GetParamater(2);
        }

		public static void Send_EntityKeyPress( DSNetworkWrapper oNetwork,DSNetworkPlayer oSendTo,
												Entity oEntityPKeyGettingKey,Microsoft.DirectX.DirectInput.Key oKey,bool bPressed )
		{
			DSNetworkPacket oPacket = NetMsg.Pckt_EntityKeyPress( oEntityPKeyGettingKey,oKey,bPressed );
			oNetwork.SendMsg( oSendTo,oPacket );
		}
		public static DSNetworkPacket Pckt_EntityKeyPress( Entity oEntityPKeyGettingKey,Microsoft.DirectX.DirectInput.Key oKey,bool bPressed )
		{
			DSSerialize oSerialize = new DSSerialize();
			DSNetworkPacket oPacket = null;


			oSerialize.Set( 0,oEntityPKeyGettingKey.PKeyObject.Serialize() );
			oSerialize.Set( 1,(int)oKey );
			oSerialize.Set( 2,bPressed );
		
			oPacket = new DSNetworkPacket( Convert.ToInt32( enumNetMsg.EntityKeyPress ),
					oSerialize.Serialize() );


			return( oPacket );
		}
		public static void Rcv_EntityKeyPress( DSNetworkPacket oPacket,ref string sEntityPKey,
									 		   ref Microsoft.DirectX.DirectInput.Key oKey,ref bool bPressed )
		{
			DSNetPKey oPKey = null;
			DSSerialize oSerialize = new DSSerialize();


			oSerialize.DeSerialize( (string)oPacket.GetParamater( 0 ) );
			
			oPKey = new DSNetPKey( 0,0 );
			oPKey.DeSerialize( (DSSerialize)oSerialize.Get( 0 ) );
			sEntityPKey = oPKey.ToString();

			oKey = (Microsoft.DirectX.DirectInput.Key)oSerialize.GetInt( 1 );
			bPressed = oSerialize.GetBool( 2 );
		}
        
		public static void Send_IsPatchAvailable( DSNetworkWrapper oNetwork,string sMyVersion )
		{
			DSNetworkPacket oPacket = new DSNetworkPacket( 
						Convert.ToInt32( enumNetMsg.IsPatchAvailable ),sMyVersion );
			oPacket.GuarenteedDelivery = true;

			oNetwork.SendMsg( oNetwork.PlayerWhoIsHost,oPacket );
		}
		public static void Rcv_IsPatchAvailable( DSNetworkPacket oPacket,ref string sMyVersion )
		{
			sMyVersion = (string)oPacket.GetParamater( 0 );
		}

		public static void Send_PatchAvailabilityResponse( DSNetworkWrapper oNetwork,DSNetworkPlayer oSendTo,string[] saFilesNeedingUpdates )
		{
			string sMsg = DSMisc.Join( saFilesNeedingUpdates,"[SP]" );

			DSNetworkPacket oPacket = new DSNetworkPacket( 
				Convert.ToInt32( enumNetMsg.PatchAvailabilityResponse ),sMsg );
			oPacket.GuarenteedDelivery = true;

			oNetwork.SendMsg( oSendTo,oPacket );
		}
		public static void Rcv_PatchAvailabilityResponse( DSNetworkPacket oPacket,ref string[] saFilesNeedingUpdates )
		{
			string sMsg = (string)oPacket.GetParamater( 0 );

			if( sMsg.Length == 0 )
			{
				saFilesNeedingUpdates = new string[ 0 ];
			}
			else
			{
				saFilesNeedingUpdates = DSMisc.Split( (string)oPacket.GetParamater( 0 ),"[SP]" );
			}
		}
        
		public static void Send_Respawn( DSNetworkWrapper oNetwork,long nSocketIDOfPlayerToRespawn )
		{
			DSNetworkPacket oPacket = new DSNetworkPacket( Convert.ToInt32( enumNetMsg.Respawn ),
														   nSocketIDOfPlayerToRespawn );
			oPacket.SocketIDToSendTo = nSocketIDOfPlayerToRespawn;
			oPacket.GuarenteedDelivery = true;

			oNetwork.SendMsg( oPacket );
		}
		public static void Rcv_Respawn( DSNetworkPacket oPacket,ref long nSocketIDOfPlayerToRespawn )
		{
			nSocketIDOfPlayerToRespawn = Convert.ToInt64( oPacket.GetParamater( 0 ) );
		}
        
        public static void Send_GameChat( DSNetworkWrapper oNetwork,DSNetworkPlayer oSender,DSNetworkPlayer oSendTo,string sMessage )
		{
			DSNetworkPacket oPacket = NetMsg.Pckt_GameChat( oSender,sMessage );
			oNetwork.SendMsg( oSendTo,oPacket );
		}
		public static DSNetworkPacket Pckt_GameChat( DSNetworkPlayer oSender,string sMessage )
		{
			DSNetworkPacket oPacket = new DSNetworkPacket( Convert.ToInt64( enumNetMsg.GameChat ),oSender.SocketID.ToString(),sMessage );
			return( oPacket );
		}
		public static void Rcv_GameChat( DSNetworkPacket oPacket,ref long nSenderSocketID,ref string sMessage )
		{
			nSenderSocketID = Convert.ToInt64( oPacket.GetParamater( 0 ) );
			sMessage = (string)oPacket.GetParamater( 1 );
		}
        
		public static void Send_EntityReceivesLoot( DSNetworkWrapper oNetwork,long nSocketIDOfPlayerToGetLoot,Session oSession,Item oLootItem )
		{
			DSNetworkPacket oPacket = new DSNetworkPacket( Convert.ToInt32( enumNetMsg.EntityReceivesLoot ),
														   nSocketIDOfPlayerToGetLoot,
														   oLootItem.GetType().Name,
                                                           oLootItem.Serialize(oSession));
			oPacket.SocketIDToSendTo = nSocketIDOfPlayerToGetLoot;
			oPacket.GuarenteedDelivery = true;

			oNetwork.SendMsg( oPacket );
		}
		public static void Rcv_EntityReceivesLoot( DSNetworkPacket oPacket,Session oSession,ref long nSocketIDOfPlayerToGetLoot,ref Item oLootItem )
		{
			Assembly oControlAssembly = null;
			Type oControlType = null;
			string sTypeName = "";


			//Deserialize the form into a new object... so first create the new object
			sTypeName = (string)oPacket.GetParamater( 1 );
			oControlAssembly = Assembly.Load("StellarLanes");//.LoadWithPartialName( "StellarLanes" );//(string)oChassis[ i+1 ] );
			oControlType = oControlAssembly.GetType( "DarkStride.StellarLanes.SharedDLL." + sTypeName );
			//Make it!
			oLootItem = (Item)Activator.CreateInstance( oControlType,new object[]{ null } );
			//Now deserialize the form
			oLootItem.DeSerialize( oSession,(DSSerialize)oPacket.GetParamater( 2 ) );

			nSocketIDOfPlayerToGetLoot = (long)oPacket.GetParamater( 0 );
		}
        
		public static DSNetworkPacket Pckt_EntityRemoveChassis( Entity oEntity,Chassis oChassesToRemove )
		{
			DSNetworkPacket oPacket = null;
			
			oPacket = new DSNetworkPacket( 
				Convert.ToInt32( enumNetMsg.EntityRemoveChassis ),
				oEntity.PKey,
				oChassesToRemove.PKey );
			oPacket.GuarenteedDelivery = true;

			return( oPacket );
		}
		public static void Rcv_EntityRemoveChassis( DSNetworkPacket oPacket,ref string sEntityGUID,ref string sChassisToRemoveGUID )
		{
			sEntityGUID = (string)oPacket.GetParamater( 0 );
			sChassisToRemoveGUID = (string)oPacket.GetParamater( 1 );
		}		
        
		public static void Send_SetEntityInPlayStatus( DSNetworkWrapper oNetwork,Entity oEntityToSend )
		{
			DSNetworkPacket oPacket = new DSNetworkPacket( Convert.ToInt32( enumNetMsg.SetEntityInPlayStatus ),
														   oEntityToSend.PKey,
														   oEntityToSend.IsInPlay );
			oPacket.GuarenteedDelivery = true;

			oNetwork.SendMsg( oPacket );
		}
		public static void Rcv_SetEntityInPlayStatus( DSNetworkPacket oPacket,ref string sEntityGUID,ref bool bIsInPlayFlag )
		{
			sEntityGUID = (string)oPacket.GetParamater( 0 );
			bIsInPlayFlag = (bool)oPacket.GetParamater( 1 );
		}		
        
		public static void Send_EntityMessage( DSNetworkWrapper oNetwork,DSNetworkPlayer oSender,Entity oEntityToSendTo,long nSubMessageType,string sMessage )
		{
			DSNetworkPacket oPacket = NetMsg.Pckt_EntityMessage( oEntityToSendTo,nSubMessageType,sMessage );
			oNetwork.SendMsg( oNetwork.PlayerWhoIsHost,oPacket );
		}
		public static DSNetworkPacket Pckt_EntityMessage( Entity oEntityToSendTo,long nSubMessageType,string sMessage )
		{
			DSNetworkPacket oPacket = null;
			
			try
			{
				oPacket = new DSNetworkPacket( 
					Convert.ToInt32( enumNetMsg.EntityMessage ),
					oEntityToSendTo.PKey,
					nSubMessageType,
					sMessage );
				oPacket.GuarenteedDelivery = true;
			}
			catch( System.Exception oEx )
			{
				DSMisc.ShowErrors( oEx );
			}
			return( oPacket );
		}
		public static void Rcv_EntityMessage( DSNetworkPacket oPacket,ref string sEntityPKey,ref long nSubMessageType,ref string sMessage )
		{
			sEntityPKey = (string)oPacket.GetParamater( 0 );
			nSubMessageType = (long)oPacket.GetParamater( 1 );
			sMessage = (string)oPacket.GetParamater( 2 );
		}		

		public static void Send_EntityReceivesEXP( DSNetworkWrapper oNetwork,Entity oEntity,long nAmountOfEXP )
		{
			DSNetworkPacket oPacket = new DSNetworkPacket( Convert.ToInt32( enumNetMsg.EntityReceivesEXP ),
														   oEntity.PKey,nAmountOfEXP );
			oPacket.GuarenteedDelivery = true;

			oNetwork.SendMsg( oPacket );
		}
		public static void Rcv_EntityReceivesEXP( DSNetworkPacket oPacket,ref string sEntityPKey,ref long nAmountOfEXP )
		{
			sEntityPKey = (string)oPacket.GetParamater( 0 );
			nAmountOfEXP = Convert.ToInt64( oPacket.GetParamater( 1 ) );
		}

		public static void Send_RemoveEntity( DSNetworkWrapper oNetwork,DSNetworkPlayer oSendTo,Entity oEntityToRemove )
		{
			DSNetworkPacket oPacket = NetMsg.Pckt_RemoveEntity( oEntityToRemove );
			oPacket.GuarenteedDelivery = true;
			oNetwork.SendMsg( oSendTo,oPacket );
		}
		public static DSNetworkPacket Pckt_RemoveEntity( Entity oEntityToRemove )
		{
			DSNetworkPacket oPacket = null;
			
			oPacket = new DSNetworkPacket( Convert.ToInt32( enumNetMsg.RemoveEntity ),oEntityToRemove.PKey );
			oPacket.GuarenteedDelivery = true;

			return( oPacket );
		}
		public static void Rcv_RemoveEntity( DSNetworkPacket oPacket,ref string sEntityPKey )
		{
			sEntityPKey = (string)oPacket.GetParamater( 0 );
		}		

		public static void Send_RollingText( DSNetworkWrapper oNetwork,Vector2 vPos,Vector2 vVel,int nColor,string sMsg )
		{
			DSNetworkPacket oPacket = new DSNetworkPacket( Convert.ToInt32( enumNetMsg.RollingText ),
									new object[]{
													vPos.X, vPos.Y, vVel.X, vVel.Y, nColor, sMsg
												} );
			oPacket.GuarenteedDelivery = true;

			oNetwork.SendMsg( oPacket );
		}
		public static void Rcv_RollingText( DSNetworkPacket oPacket,ref Vector2 vPos,ref Vector2 vVel,
																	ref int nColor,ref string sMsg )
		{
			float nTempX = 0;
			float nTempY = 0;

			nTempX = Convert.ToInt64( oPacket.GetParamater( 0 ) );
			nTempY = Convert.ToInt64( oPacket.GetParamater( 1 ) );
			vPos = new Vector2( nTempX,nTempY );

			nTempX = Convert.ToInt64( oPacket.GetParamater( 2 ) );
			nTempY = Convert.ToInt64( oPacket.GetParamater( 3 ) );
			vVel = new Vector2( nTempX,nTempY );

			nColor = Convert.ToInt32( oPacket.GetParamater( 4 ) );
			sMsg = (string)oPacket.GetParamater( 5 );
		}

		public static void Send_StartWave( DSNetworkWrapper oNetwork,long nWaveStarting )
		{
			DSNetworkPacket oPacket = new DSNetworkPacket( Convert.ToInt32( enumNetMsg.StartWave ),
											nWaveStarting  );
			oPacket.GuarenteedDelivery = true;

			oNetwork.SendMsg( oPacket );
		}
		public static void Rcv_StartWave( DSNetworkPacket oPacket,ref long nWaveStarting )
		{
			nWaveStarting = Convert.ToInt64( oPacket.GetParamater( 0 ) );
		}
	}
}
